/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.logger;

import io.gitlab.jfronny.commons.logger.LeveledLoggerFinder;
import io.gitlab.jfronny.commons.logger.PrintStreamLogger;
import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;

public class StdoutLogger
extends PrintStreamLogger {
    public static final LeveledLoggerFinder FANCY = new FancyFinder();
    private static final PrintStream stdout = StdoutLogger.newPrintStream(new FileOutputStream(FileDescriptor.out), System.getProperty("stdout.encoding"));

    public StdoutLogger(@Nullable String name, System.Logger.Level level) {
        this(name, level, false);
    }

    public StdoutLogger(@Nullable String name, System.Logger.Level level, boolean color) {
        this(name, level, color, false, false);
    }

    public StdoutLogger(@Nullable String name, System.Logger.Level level, boolean color, boolean thread, boolean timestamp) {
        super(stdout, name, level, color, thread, timestamp);
    }

    private static PrintStream newPrintStream(OutputStream out, String enc) {
        if (enc != null) {
            return new PrintStream((OutputStream)new BufferedOutputStream(out, 128), true, Charset.forName(enc, StandardCharsets.UTF_8));
        }
        return new PrintStream(new BufferedOutputStream(out, 128), true);
    }

    public static StdoutLogger fancy(String name, System.Logger.Level level) {
        return new StdoutLogger(name, level, true, true, true);
    }

    public static StdoutLogger fancy(String name, Module module, System.Logger.Level level) {
        return StdoutLogger.fancy(name, level);
    }

    private static class FancyFinder
    extends LeveledLoggerFinder {
        private FancyFinder() {
        }

        @Override
        public SystemLoggerPlus getLogger(String name, Module module, @Nullable System.Logger.Level level) {
            return StdoutLogger.fancy(name, module, level);
        }
    }
}

